<?php

/**
 * Prevent Direct Access
 */
defined( 'ABSPATH' ) or die( "Restricted access!" );

/**
 * Register text domain
 */
function spacexchimp_p001_textdomain() {
    load_plugin_textdomain( SPACEXCHIMP_P001_TEXT, false, SPACEXCHIMP_P001_DIR . '/languages/' );
}
add_action( 'init', 'spacexchimp_p001_textdomain' );

/**
 * Print direct link to plugin admin page
 *
 * Fetches array of links generated by WordPress Plugin admin page ( Deactivate | Edit )
 * and inserts a link to the plugin admin page
 */
function spacexchimp_p001_settings_link( $links ) {
    $page = '<a href="' . admin_url( 'options-general.php?page=' . SPACEXCHIMP_P001_SLUG ) . '">' . __( 'Settings', SPACEXCHIMP_P001_TEXT ) . '</a>';
    array_unshift( $links, $page );
    return $links;
}
add_filter( 'plugin_action_links_' . SPACEXCHIMP_P001_BASE, 'spacexchimp_p001_settings_link' );

/**
 * Print link to My Custom Functions PRO page
 */
function spacexchimp_p001_upgrade_link( $links ) {
    $upgrade_page = '<a href="https://www.spacexchimp.com/plugins/my-custom-functions-pro.html" target="_blank"><b style="color:red;">' . __( 'Upgrade to PRO', SPACEXCHIMP_P001_TEXT ) . '</b></a>';
    array_unshift( $links, $upgrade_page );
    return $links;
}
add_filter( 'plugin_action_links_' . SPACEXCHIMP_P001_BASE, 'spacexchimp_p001_upgrade_link' );

/**
 * Print additional links to plugin meta row
 */
function spacexchimp_p001_plugin_row_meta( $links, $file ) {

    if ( strpos( $file, SPACEXCHIMP_P001_SLUG . '.php' ) !== false ) {

        $new_links = array(
                           'donate' => '<a href="https://www.spacexchimp.com/donate.html" target="_blank"><span class="dashicons dashicons-heart"></span> ' . __( 'Donate', SPACEXCHIMP_P001_TEXT ) . '</a>',
                           'upgrage' => '<a href="https://www.spacexchimp.com/plugins/my-custom-functions-pro.html" target="_blank"><span class="dashicons dashicons-star-filled"></span> ' . __( 'Upgrade to PRO', SPACEXCHIMP_P001_TEXT ) . '</a>'
                           );
        $links = array_merge( $links, $new_links );
    }

    return $links;
}
add_filter( 'plugin_row_meta', 'spacexchimp_p001_plugin_row_meta', 10, 2 );

/**
 * Register a submenu item in the top-level menu item "Settings"
 */
function spacexchimp_p001_register_submenu_page() {

    $page_title  = SPACEXCHIMP_P001_NAME;
    $menu_title  = __( 'PHP Inserter', SPACEXCHIMP_P001_TEXT );
    $capability  = 'manage_options';
    $menu_slug   = SPACEXCHIMP_P001_SLUG;
    $function    = 'spacexchimp_p001_render_submenu_page';

    add_options_page( $page_title, $menu_title, $capability, $menu_slug, $function );
}
add_action( 'admin_menu', 'spacexchimp_p001_register_submenu_page' );

/**
 * Register settings
 */
function spacexchimp_p001_register_settings() {
    register_setting( SPACEXCHIMP_P001_SETTINGS . '_settings_group', SPACEXCHIMP_P001_SETTINGS . '_settings' );
    register_setting( SPACEXCHIMP_P001_SETTINGS . '_settings_group_si', SPACEXCHIMP_P001_SETTINGS . '_service_info' );
    register_setting( SPACEXCHIMP_P001_SETTINGS . '_settings_group', SPACEXCHIMP_P001_SETTINGS . '_error' );
}
add_action( 'admin_init', 'spacexchimp_p001_register_settings' );

/**
 * Branded footer text on the plugin's settings page
 */
function spacexchimp_p001_admin_footer_text() {

    // Get current screen data
    $current_screen = get_current_screen();

    // Return if the page is not a settings page of this plugin
    $settings_page = 'settings_page_' . SPACEXCHIMP_P001_SLUG;
    if ( $settings_page != $current_screen->id ) return;

    // Filter footer text
    function spacexchimp_p001_new_admin_footer_text() {
        $year = date('Y');
        return "Copyright &copy; " . $year . " <a href='https://www.spacexchimp.com' target='_blank'>Space X-Chimp</a> | Click <a href='https://www.spacexchimp.com/store.html' target='_blank'>here</a> to see our other products.";
    }
    add_filter( 'admin_footer_text', 'spacexchimp_p001_new_admin_footer_text', 11 );
}
add_action( 'current_screen', 'spacexchimp_p001_admin_footer_text' );

/**
 * Runs during the plugin activation
 */
function spacexchimp_p001_activation() {

    // Read the plugin service information from the database and put it into an array
    $info = get_option( SPACEXCHIMP_P001_SETTINGS . '_service_info' );

    // Make the "$info" array if the plugin service information in the database is not exist
    if ( ! is_array( $info ) ) $info = array();

    // Get the activation date of the plugin from the database
    $activation_date = !empty( $info['activation_date'] ) ? $info['activation_date'] : '';

    if ( $activation_date == '' ) {
        $info['activation_date'] = time();
        update_option( SPACEXCHIMP_P001_SETTINGS . '_service_info', $info );
    }
}
register_activation_hook( SPACEXCHIMP_P001_FILE, 'spacexchimp_p001_activation' );

/**
 * Delete options on uninstall
 */
function spacexchimp_p001_uninstall() {
    delete_option( SPACEXCHIMP_P001_SETTINGS . '_settings' );
    delete_option( SPACEXCHIMP_P001_SETTINGS . '_error' );
}
register_uninstall_hook( SPACEXCHIMP_P001_FILE, 'spacexchimp_p001_uninstall' );
