/**
 * FloatMenu
 * A JavaScript class for creating customizable side menus.
 *
 * @version 7.1
 * @license MIT License
 * @author Dmytro Lobov
 * @url https://wow-estore.com/item/float-menu-pro/
 */
"use strict";class FloatMenu{static ATTR="data-float-menu";static initialize(){window.floatMenus={},document.querySelectorAll(`[${FloatMenu.ATTR}]`).forEach((e=>{const t=new FloatMenu(e),s=e.className.match(/float-menu-(\d+)/);if(s&&s[1]){const e=s[1];window.floatMenus[e]=t}}))}constructor(e,t={}){if(!(e instanceof HTMLElement))return;if(this.element=e,this.config=Object.assign({},{position:["left","center"]},this.#e(),t),null===this.config)return;if(this.items=e.querySelectorAll(".fm-item"),this.links=e.querySelectorAll(".fm-link"),this.labels=e.querySelectorAll(".fm-label"),0===this.items.length)return;this.itemWidth=this.items[0].offsetWidth+15,this.config?.remove&&this.element.removeAttribute(FloatMenu.ATTR),this.init()}init(){this.screen(),window.addEventListener("resize",this.screen.bind(this)),this.mobileStyle(),window.addEventListener("resize",this.mobileStyle.bind(this)),this.labelDisabele(),this.mobileClick(),this.position(),this.appearance(),this.setLinkProperties(),this.setSubMenu(),this.extraText(),this.visibleMenu(),this.closePopup()}appearance(){this.config?.appearance&&(this.config?.appearance?.shape&&this.element.classList.add(this.config?.appearance?.shape),this.config?.appearance?.sideSpace&&this.element.classList.add("-side-space"),this.config?.appearance?.buttonSpace&&this.element.classList.add("-button-space"),this.config?.appearance?.labelConnected&&this.element.classList.add("-label-connect"),this.config?.appearance?.subSpace&&this.element.classList.add("-sub-space"))}labelDisabele(){if(!this.config?.label?.off)return!1;this.links.forEach((e=>{e.classList.add("-label-hidden")}))}screen(){if(!this.config?.screen)return;const{small:e,large:t}=this.config.screen,s=window.innerWidth,i=()=>{this.element.classList.add("fm-hidden")},n=()=>{this.element.classList.remove("fm-hidden")};void 0!==e&&s<=e||void 0!==t&&s>=t?i():(void 0===e||void 0===t||s>e&&s<t)&&n()}closePopup(){const e=this.element.querySelectorAll(".fm-window");0!==e.length&&e.forEach((e=>{const t=e.querySelector(".fm-close");t&&t.addEventListener("click",(()=>{e.close()})),e.addEventListener("click",(function({currentTarget:e,target:t}){const s=e;t===s&&s.close()}))}))}extraText(){const e=this.element.querySelectorAll(".fm-extra-text");0!==e.length&&e.forEach((e=>{const t=parseFloat(this.config?.label?.space)||0;e.style.setProperty("--text_margin",t);const s=e.closest(".fm-item"),i=s.querySelector(".fm-link");s.addEventListener("mouseenter",(()=>{i.classList.toggle("-active")})),s.addEventListener("mouseleave",(()=>{i.classList.remove("-active")}))}))}visibleMenu(){if((!this.config.visible||this.config.visible.every((e=>"show"===e||"0"===e)))&&(!this.config.time||this.config.time.every((e=>"show"===e||"0"===e))))return void this.element.classList.add("fm-ready");let e=!1;const t=()=>{e||(this.element.classList.add("fm-ready"),e=!0)},s=()=>{e&&(this.element.classList.remove("fm-ready"),e=!1)};if(this.config.time){const e=this.config.time||["show","0"],[i,n]=e,o=Number(n);"show"===i&&o>0&&setTimeout(t,1e3*o),"hide"===i&&o>0&&(t(),setTimeout(s,1e3*o))}if(this.config.visible){const e=this.config.visible||["show","0"],[i,n]=e,o=Number(n);"hide"===i&&t(),window.addEventListener("scroll",(()=>{const e=window.scrollY||document.documentElement.scrollTop;"show"===i&&(e>=o?t():s()),"hide"===i&&(e>o?s():t())}))}}mobileStyle(){if(!this.config?.mobile)return;const e=window.innerWidth,t=parseInt(this.config?.mobile[0])||0,s=parseInt(this.config?.mobile[1])||24,i=parseInt(this.config?.mobile[2])||15,n=parseInt(this.config?.mobile[3])||0,o=parseInt(this.config?.mobile[4])||12;e<t&&(this.element.style.setProperty("--fm-icon-size",s),this.element.style.setProperty("--fm-label-size",i),this.element.style.setProperty("--fm-icon-text",o),0!==n&&this.element.style.setProperty("--fm-icon-box",n))}mobileClick(){this._isMobile()&&this.config?.mobileRules&&(this.links.forEach((e=>{e.addEventListener("click",(t=>{e.classList.contains("-active")||(t.preventDefault(),t.stopImmediatePropagation(),this.links.forEach((e=>{e.classList.remove("-active")})),e.classList.add("-active"),clearTimeout(undefined),setTimeout((()=>{e.classList.remove("-active"),e.blur()}),3e3))}))})),document.addEventListener("click",(e=>{this.element.contains(e.target)||this.links.forEach((e=>{const t=e.closest(".fm-item");e.classList.remove("-active"),t.classList.remove("-active")}))})))}position(){let e=this.config?.position[0]||"left",t=this.config?.position[1]||"center";this.element.classList.add(`-${e}`),this.element.classList.add(`-${t}`);const s=this.element.getBoundingClientRect();let i=0,n=0;if(this.config?.offset&&(i=parseInt(this.config?.offset[0]),n=parseInt(this.config?.offset[1])),0!==i&&this.element.style.setProperty("--fm-offset",`${i}px`),"top"===t){let e=s.top+n;this.element.style.top=`${e}px`}else if("center"===t){let e=s.top+n;e-=this.element.offsetHeight/2,this.element.style.top=`${e}px`}else if("bottom"===t){let e=-1*n;this.element.style.bottom=`${e}px`}}setLinkProperties(){const e=parseFloat(this.config?.label?.space)||0,t=this.config?.label?.effect||"none";this.links.forEach((s=>{let i=s.querySelector(".fm-label").offsetWidth+e;const n=s.offsetWidth;s.classList.contains("fm-hold-open")&&(i=i-n+12),s.style.setProperty("--_width",i),s.classList.add(`-${t}`)}))}setSubMenu(){if(!this.config?.sub)return;const e=this.element.querySelectorAll(".fm-has-sub");if(0===e.length)return;const t=this.config?.sub?.position||"under",s=this.config?.sub?.effect||"none",i=this.config?.sub?.open||"click";let n=null;e.forEach((e=>{e.classList.add(`fm-sub-${t}`),e.classList.add(`-sub-${s}`);const o=[];let l=e.previousElementSibling;for(;l;)l.classList.contains("fm-item")&&o.push(l),l=l.previousElementSibling;this.setSubProperties(e,s,t);const c=e.querySelector(".fm-link");"click"===i||this._isMobile()?(c.addEventListener("click",(e=>{e.preventDefault()})),e.addEventListener("click",(s=>{s.stopPropagation(),n&&n!==e&&this.closeSubMenu(n,t),n&&n.contains(s.target)&&(s.target.matches(".fm-sub")||s.target.closest(".fm-link"))&&c&&!c.contains(s.target)||(e.classList.toggle("-active"),n=e.classList.contains("-active")?e:null,"circular"===t&&(c.classList.toggle("-label-hidden"),o.length>0&&o.forEach((e=>{e.classList.toggle("-hidden")}))))}))):(e.addEventListener("mouseenter",(()=>{const s=e.querySelector(".fm-link");e.classList.add("-active"),s.classList.contains("-active")||s.classList.add("-active"),"circular"===t&&(s.classList.toggle("-label-hidden"),o.length>0&&o.forEach((e=>{e.classList.toggle("-hidden")})))})),e.addEventListener("mouseleave",(()=>{this.closeSubMenu(e,t)})))})),document.addEventListener("click",(e=>{n&&!n.contains(e.target)&&(this.closeSubMenu(n,t),n=null)}))}closeSubMenu(e,t){const s=e.querySelector(".fm-link");if(e.classList.remove("-active"),s.classList.contains("fm-hold-open")?s.classList.add("-active"):s.classList.remove("-active"),"circular"===t){s.classList.toggle("-label-hidden");const e=this.element.querySelectorAll(".fm-item.-hidden");e.length>0&&e.forEach((e=>{e.classList.remove("-hidden")}))}}setSubProperties(e,t,s){const i=e.querySelector(".fm-sub"),n=i.offsetHeight;"circular"!==s&&e.style.setProperty("--_offset",n);const o=i.querySelectorAll(".fm-item"),l=parseInt(this.config?.sub?.speed)||0,c=o.length,a=l/c;let r=o[0].offsetWidth;"linear-fade"===t&&o.length>0&&o.forEach(((e,t)=>{const s=t*a,i=(c-1-t)*a;e.style.setProperty("--_delay",`${s}`),e.style.setProperty("--_close_delay",`${i}`)})),"linear-slide"===t&&o.length>0&&o.forEach(((e,t)=>{const s=(t+1)*r*-1;e.style.setProperty("--_top",`${s}px`)})),"circular"===s&&this.subMenuCircular(i,o,e)}subMenuCircular(e,t,s){const i=this.itemWidth,n=this.calculateAngleIncrement(t.length);let o=this.calculateOptimalRadius(i,n);const l=1.5*i;o<l&&(o=l),s.style.setProperty("--_offset",o),s.style.setProperty("--_box",o),this.setMenuProperties(t,n,o,e,i)}setMenuProperties(e,t,s,i,n){const o=s+2;i.classList.contains("-active")?i.style.setProperty("margin-bottom",`${o}px`):i.style.setProperty("margin-bottom","unset");const l=(parseInt(this.config?.sub?.speed)||0)/e.length;e.forEach(((n,o)=>{const c=e.length-1-o,a=this.determineAngleForMenu(i,t,o,c);this.styleMenuItem(n,i,s,a,o,l)}))}determineAngleForMenu(e,t,s,i){const n=this.config?.position[0]||"left";return"left"===n?t*s-Math.PI/2:"right"===n?t*i+Math.PI/2:void 0}styleMenuItem(e,t,s,i,n,o){const l=n*o,c=s*Math.cos(i),a=s*Math.sin(i);e.style.setProperty("--x",`${c}px`),e.style.setProperty("--y",`${a}px`),e.style.setProperty("--_delay",`${l}`)}calculateAngleIncrement(e){return Math.PI/(e-1)}calculateOptimalRadius(e,t){return e/2/Math.sin(t/2)}#e(){const e=this.element.getAttribute(`${FloatMenu.ATTR}`);if(!e||""===e.trim())return{};try{return JSON.parse(e)}catch(e){return{}}}_isMobile(){return/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)||window.innerWidth<=768||"ontouchstart"in window||navigator.maxTouchPoints>0}_isObjEmpty(e){return e&&"object"==typeof e&&0===Object.keys(e).length}_showConfig(){console.log(this.config)}}document.addEventListener("DOMContentLoaded",(function(){FloatMenu.initialize()}));