<?php
/*
Plugin Name: MihanFactor
Description: افزونه‌ای برای ثبت و نمایش فاکتور در وردپرس
Version: 1.2
Author: میهن آکادمی
*/

// جلوگیری از دسترسی مستقیم
if (!defined('ABSPATH')) {
    exit;
}

// ایجاد جدول فاکتورها هنگام فعال‌سازی
function mihanfactor_create_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'mihanfactor';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        customer_name varchar(255) NOT NULL,
        product_name varchar(255) NOT NULL,
        quantity int NOT NULL,
        total_amount float NOT NULL,
        date datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'mihanfactor_create_table');

// ثبت فاکتور در دیتابیس
function mihanfactor_add_invoice($customer_name, $product_name, $quantity, $total_amount) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'mihanfactor';

    $wpdb->insert(
        $table_name,
        array(
            'customer_name' => $customer_name,
            'product_name' => $product_name,
            'quantity' => $quantity,
            'total_amount' => $total_amount,
        ),
        array('%s', '%s', '%d', '%f')
    );
}

// نمایش فرم و لیست فاکتورها
function mihanfactor_dashboard() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'mihanfactor';

    // استایل سفارشی برای پنل مدیریت
    echo '<style>
        .mihanfactor-container { max-width: 800px; margin: 20px auto; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        .mihanfactor-container h2 { text-align: center; color: #333; }
        .mihanfactor-form input { width: 100%; padding: 10px; margin: 5px 0; border: 1px solid #ddd; border-radius: 5px; }
        .mihanfactor-form button { width: 100%; background: #0073aa; color: #fff; padding: 10px; border: none; border-radius: 5px; cursor: pointer; }
        .mihanfactor-form button:hover { background: #005177; }
        .mihanfactor-table { width: 100%; margin-top: 20px; border-collapse: collapse; }
        .mihanfactor-table th, .mihanfactor-table td { padding: 10px; border: 1px solid #ddd; text-align: center; }
        .mihanfactor-table th { background: #0073aa; color: #fff; }
        .mihanfactor-table tr:nth-child(even) { background: #f9f9f9; }
    </style>';

    // نمایش فرم ثبت فاکتور
    echo '<div class="mihanfactor-container">';
    echo '<h2>ثبت فاکتور جدید</h2>';
    echo '<form method="post" class="mihanfactor-form">';
    wp_nonce_field('mihanfactor_save_invoice', 'mihanfactor_nonce');
    echo '<input type="text" name="customer_name" placeholder="نام مشتری" required>';
    echo '<input type="text" name="product_name" placeholder="نام محصول" required>';
    echo '<input type="number" name="quantity" placeholder="تعداد" required>';
    echo '<input type="number" name="total_amount" placeholder="مبلغ کل" step="0.01" required>';
    echo '<button type="submit" name="submit_invoice">ثبت فاکتور</button>';
    echo '</form>';

    // دریافت فاکتورها از دیتابیس
    $invoices = $wpdb->get_results("SELECT * FROM $table_name ORDER BY id DESC");

    // نمایش جدول فاکتورها
    echo '<h2>فاکتورهای ثبت‌شده</h2>';
    if ($invoices) {
        echo '<table class="mihanfactor-table">
            <tr>
                <th>شماره فاکتور</th>
                <th>نام مشتری</th>
                <th>محصول</th>
                <th>تعداد</th>
                <th>مبلغ کل</th>
                <th>تاریخ</th>
            </tr>';
        foreach ($invoices as $invoice) {
            echo "<tr>
                <td>{$invoice->id}</td>
                <td>{$invoice->customer_name}</td>
                <td>{$invoice->product_name}</td>
                <td>{$invoice->quantity}</td>
                <td>{$invoice->total_amount} تومان</td>
                <td>{$invoice->date}</td>
            </tr>";
        }
        echo '</table>';
    } else {
        echo '<p>هنوز فاکتوری ثبت نشده است.</p>';
    }
    echo '</div>';
}

// پردازش فرم ثبت فاکتور
function mihanfactor_process_form() {
    if (isset($_POST['submit_invoice'])) {
        if (!current_user_can('manage_options')) {
            wp_die('شما دسترسی لازم را ندارید.');
        }
        if (!isset($_POST['mihanfactor_nonce']) || !wp_verify_nonce($_POST['mihanfactor_nonce'], 'mihanfactor_save_invoice')) {
            wp_die('درخواست نامعتبر.');
        }

        $customer_name = sanitize_text_field($_POST['customer_name']);
        $product_name = sanitize_text_field($_POST['product_name']);
        $quantity = intval($_POST['quantity']);
        $total_amount = floatval($_POST['total_amount']);

        mihanfactor_add_invoice($customer_name, $product_name, $quantity, $total_amount);

        add_action('admin_notices', function () {
            echo '<div class="updated"><p>فاکتور با موفقیت ثبت شد!</p></div>';
        });

        // ریدایرکت برای جلوگیری از ارسال مجدد فرم
        wp_redirect(admin_url('admin.php?page=mihanfactor'));
        exit;
    }
}
add_action('admin_init', 'mihanfactor_process_form');

// افزودن صفحه مدیریت فاکتورها به منوی وردپرس
function mihanfactor_menu() {
    add_menu_page(
        'مدیریت فاکتورها',
        'MihanFactor',
        'manage_options',
        'mihanfactor',
        'mihanfactor_dashboard',
        'dashicons-clipboard',
        6
    );
}
add_action('admin_menu', 'mihanfactor_menu');
?>
